<div class="dashboard-container">
    <div class="dashboard-header">
        <h1>Dashboard</h1>
        <p>Welcome back, <?php echo htmlspecialchars($auth->getUserEmail()); ?></p>
    </div>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">🌐</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo $stats['total_websites'] ?? 0; ?></div>
                <div class="stat-label">Total Websites</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">📊</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo number_format($stats['avg_visibility_score'] ?? 0, 1); ?>%</div>
                <div class="stat-label">Avg Visibility Score</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">✅</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo $stats['active_websites'] ?? 0; ?></div>
                <div class="stat-label">Active Websites</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">🕒</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo $stats['last_scan_at'] ? date('M j', strtotime($stats['last_scan_at'])) : 'Never'; ?></div>
                <div class="stat-label">Last Scan</div>
            </div>
        </div>
    </div>
    
    <div class="dashboard-section">
        <div class="section-header">
            <h2>Recent Websites</h2>
            <a href="/dashboard/websites/add" class="btn btn-primary">Add Website</a>
        </div>
        
        <?php if (!empty($recent_websites)): ?>
            <div class="website-list">
                <?php foreach ($recent_websites as $website): ?>
                    <div class="website-card">
                        <div class="website-info">
                            <h3>
                                <a href="/dashboard/websites/<?php echo $website['id']; ?>">
                                    <?php echo htmlspecialchars($website['name']); ?>
                                </a>
                            </h3>
                            <p class="website-url"><?php echo htmlspecialchars($website['url']); ?></p>
                            <?php if ($website['industry']): ?>
                                <span class="industry-badge"><?php echo htmlspecialchars($website['industry']); ?></span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="website-metrics">
                            <div class="metric">
                                <span class="metric-label">Visibility</span>
                                <span class="metric-value"><?php echo number_format($website['avg_visibility_score'] ?? 0, 1); ?>%</span>
                            </div>
                            <div class="metric">
                                <span class="metric-label">Mentions</span>
                                <span class="metric-value"><?php echo $website['mention_count'] ?? 0; ?></span>
                            </div>
                            <div class="metric">
                                <span class="metric-label">Recommendations</span>
                                <span class="metric-value"><?php echo $website['recommendation_count'] ?? 0; ?></span>
                            </div>
                        </div>
                        
                        <div class="website-actions">
                            <a href="/dashboard/websites/<?php echo $website['id']; ?>" class="btn btn-sm btn-outline">View</a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="section-footer">
                <a href="/dashboard/websites" class="btn btn-secondary">View All Websites</a>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <div class="empty-icon">🌐</div>
                <h3>No websites yet</h3>
                <p>Add your first website to start tracking your AI visibility</p>
                <a href="/dashboard/websites/add" class="btn btn-primary">Add Your First Website</a>
            </div>
        <?php endif; ?>
    </div>
    
    <?php if (!empty($recent_jobs)): ?>
        <div class="dashboard-section">
            <div class="section-header">
                <h2>Recent AI Tests</h2>
            </div>
            
            <div class="job-list">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Website</th>
                            <th>Test Type</th>
                            <th>Model</th>
                            <th>Status</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recent_jobs as $job): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($job['website_name']); ?></td>
                                <td>
                                    <span class="test-type type-<?php echo $job['type']; ?>">
                                        <?php echo ucwords(str_replace('_', ' ', $job['type'])); ?>
                                    </span>
                                </td>
                                <td><?php echo htmlspecialchars($job['model_name']); ?></td>
                                <td>
                                    <span class="job-status status-<?php echo $job['status']; ?>">
                                        <?php echo ucfirst($job['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('M j, Y H:i', strtotime($job['created_at'])); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
</div>